var HMI_device = "HMI_Dom";
defineVirtualDevice(HMI_device, 
                    {
                      title: "  HMI",
                      cells: {
                      }
                    }
                   );

function HMI_add_dev_and_err(topic_src, topic_dst, devtitle, addendum){
  if (!getDevice(HMI_device).isControlExists(topic_dst)) {
    getDevice(HMI_device).addControl(topic_dst,{
      title: devtitle,
      type: "text",
      value: "",
      readonly: true
    });
  }
  if (!getDevice(HMI_device).isControlExists(topic_dst + "_err")) {
    getDevice(HMI_device).addControl(topic_dst + "_err",{
      title: devtitle + " ",
      type: "switch",
      value: false,
      readonly: false
    });
  }
  
  defineRule(HMI_device + "_error_rule_" + topic_dst, {
    when: cron("@every 1s"),
    then: function () {
      //  
      var is_err = false;
      if (!getControl(topic_src)) { is_err = true; log("getctrl"); }
      if (dev[topic_src + "#error"]) { is_err = true; log("errtopic " + dev[topic_src + "#error"]); }
      dev[HMI_device + "/" + topic_dst + "_err"] = is_err;

      //  
      if(is_err == false){
        dev[HMI_device + "/" + topic_dst] = dev[topic_src].toString() + addendum;
      }
      else{
        dev[HMI_device + "/" + topic_dst] = "---" + addendum;
      }
    }
  });
};

HMI_add_dev_and_err("th-20-rs_10/ ", "outside_temp", "  ", "");
HMI_add_dev_and_err("th-20-rs_10/ ", "outside_hum", "  ", "%");
